//------------------------------------------------------------
// VelociBus_4X4BP Event Callback Example
// Turns on all LEDs in row & column of button pressed
//------------------------------------------------------------

#include "VelociBus_4X4BP.h"
#define VBUS_SERIAL Serial2
// VelociBus superclass to handle 2x2 board arrangement
class VelociBus_2x2_boards : public VelociBus_4X4BP
{
  // The "Initialization & Diagnostic" example can be used to identify the board arrangement.

  // Board arrangement:
  //   01234567
  //   +---+---+ 0
  //   | 3 | 2 | 1 
  //   +---+---+ 2
  //   | 1 | 0 |...
  //   +---+---+ 7
  #define BOARD_ROWS 2
  #define BOARD_COLS 2
  
  private:
    const byte board_map[BOARD_ROWS][BOARD_COLS] = { {3,2}, {1,0} };

  public:
    void setRow( byte row_index, 
                 lamp_fcn fcn, color_code color )
    {
      for (uint brd=0; brd < BOARD_ROWS; brd++) setLEDrow( board_map[row_index/4][brd], row_index % 4, fcn, color );
    }
    
    void setCol( byte col_index, 
                 lamp_fcn fcn, color_code color )
    {
      for (uint brd=0; brd < BOARD_COLS; brd++) setLEDcol( board_map[brd][col_index/4], col_index % 4, fcn, color );
    }

    void setXY( byte row_index, 
                byte col_index,  
                lamp_fcn fcn, color_code color )
    {
      setLED( board_map[row_index/4][col_index/4], 4*(row_index % 4) + col_index % 4, fcn, color );
    }

    struct xy_info // information returned by getXY()
    { byte x;
      byte y;
      VelociBus_4X4BP::button_event_code event;
    };
    boolean getXY( xy_info *return_info ) // true if button event is being returned
    {
      VelociBus_4X4BP::button_info btn;
      if (!getButton( &btn )) return false;
      // locate board
      for (uint r=0; r < BOARD_ROWS; r++)
        for (uint c=0; c < BOARD_COLS; c++)
          if (board_map[r][c] == btn.board_address)
          {
            return_info->x = c*4 + (btn.button_index % 4);
            return_info->y = r*4 +  btn.button_index / 4;
            return_info->event = btn.event;
            return true;     
          }
      return false; // failsafe
    }      
};
VelociBus_2x2_boards vbus; // create VelociBus interface

void setup() 
{
  Serial.begin(115200); // Serial monitor
  // button module on VeliciBus
  VBUS_SERIAL.begin(38400);    // VelociBus is always 38400
  // establish communication
  for (;;)
  { Serial.println("PROBING VelociBus...");
    if (vbus.begin( &VBUS_SERIAL )) break; // performs loopback diagnostic, tries 3 times, sets board_count
    delay(1000);
  }
  Serial.println("VelociBus Ok");
  // all we want is press & release events
  vbus.setButtonHoldEnable( false ); // don't report long press events
  // turn off all LEDs
  vbus.setLEDall( VelociBus_4X4BP::BOARD_BROADCAST_ADDR, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::black );
}

void loop() 
{
  VelociBus_2x2_boards::xy_info btn;
  if (vbus.getXY(&btn))
  {
    if (btn.event == VelociBus_4X4BP::BTN_PRESS)
    { // turn on all LEDs in button row
      vbus.setRow( btn.y, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::red );
      // turn on all LEDs in button column
      vbus.setCol( btn.x, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::red );
    }
    else // blank all LEDs on button release
      vbus.setLEDall( VelociBus_4X4BP::BOARD_BROADCAST_ADDR, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::black );
  }
}
